/////////////////////////////////////////////////////////////////////////
// Copyright DVDVideoSoft.com
// Version 1.0.0.0
// Background page scripts
/////////////////////////////////////////////////////////////////////////

// Global background vars
var idmManager; //	dvs download manager plugin
var youtubeDownloadApplications;
var _gaq;

/////////////////////////////////////////////////////////////////////////
// Creating Context menu	
function createContextMenu() {
	// Creating main context menu
	for (var i=0; i<youtubeDownloadApplications.length; i++) {
		var appID=youtubeDownloadApplications[i].appID;
		var menuProperties={
		"type": "normal", // "normal", "checkbox", "radio", "separator"
		"title": youtubeDownloadApplications[i].contextMenuName,
		//"checked": true,
		"onclick": onContextMenuClick
		//"contexts": "",
		//"parentId": "",
		//"documentUrlPatterns": "",
		//"targetUrlPatterns": ""
		};
		if(youtubeDownloadApplications[i].visible)
			youtubeDownloadApplications[i].menuIds[youtubeDownloadApplications[i].menuIds.length]=chrome.contextMenus.create(menuProperties, onContextMenuCreated);
	}
	// Creating link context menu
	for (var i=0; i<youtubeDownloadApplications.length; i++) {
		var appID=youtubeDownloadApplications[i].appID;
		var menuProperties={
		"type": "normal", // "normal", "checkbox", "radio", "separator"
		"title": youtubeDownloadApplications[i].contextMenuName,
		//"checked": true,
		"onclick": onContextLinkMenuClick ,
		"contexts": ["link"],
		//"parentId": "",
		//"documentUrlPatterns": "",
		//"targetUrlPatterns": ""
		};
		if(youtubeDownloadApplications[i].visible)
			youtubeDownloadApplications[i].menuIds[youtubeDownloadApplications[i].menuIds.length]=chrome.contextMenus.create(menuProperties, onContextMenuCreated);
	}
}

function onContextMenuCreated() {
	var lastError=chrome.extension.lastError;
}

function onContextMenuClick (info, tab) {
	runApplications(info.pageUrl,info.menuItemId,"mainMenu");
}

function onContextLinkMenuClick (info, tab) {
	runApplications(info.linkUrl,info.menuItemId,"linkMenu");
}

function runApplications(url, menuId,eventType) {
	for (var i=0; i < youtubeDownloadApplications.length; i++) {
		for (var j=0; j < youtubeDownloadApplications[i].menuIds.length; j++) {
			if(youtubeDownloadApplications[i].menuIds[j] == menuId) {
				youtubeDownloadApplications[i].Run(url);
			}
		}
	}
}

function addListenerForContentScript() {
	chrome.extension.onRequest.addListener( 
	function (param, sender, sendResponse) {
		switch (param.method) {
			case "run":
				var result={"boolResult":false};
				idmManager.download(param.appID,param.url);
				result.boolResult=true;
	
				if(result.boolResult==false) {
					chrome.tabs.create({"active":true, "url":"errorRunProgramm.html"});
				}
				sendResponse(result);
			break;
			case "getOptions":
				result={"boolResult":true};
				result.objectResult={ 	"showButtonsVideo": (localStorage["showButtonsVideo"] == "false") ? false : true ,
										"showButtonsMP3":(localStorage["showButtonsMP3"] == "false") ? false : true ,
										"showButtonsOnvideoPage":(localStorage["showButtonsOnvideoPage"] == "false") ? false : true ,
										"showButtonsOnChannelPage":(localStorage["showButtonsOnChannelPage"] == "false") ? false : true ,
										"showButtonsOnPlaylistPage":(localStorage["showButtonsOnPlaylistPage"] == "false") ? false : true ,
										"showPanelOnChannelPage":(localStorage["showPanelOnChannelPage"] == "false") ? false : true ,
										"showPanelOnPlaylistPage":(localStorage["showPanelOnPlaylistPage"] == "false") ? false : true };
				sendResponse(result);
			break;	
			case "getApplications":
				result={"boolResult":true, "apps":youtubeDownloadApplications};
				sendResponse(result);
			break;
			case "isAppEnabled":
				result={"boolResult":true, "isAppEnabled":Array()};
				for (var i=0; i< param.apps.length; i++) {
					//tempor
					result.isAppEnabled[i]=idmManager.isAppEnabled(param.apps[i].appID);
					//result.isAppEnabled[i]=true;
				}
				sendResponse(result);
			default:
			break;
		}
	});
}


/////////////////////////////////////////////////////////////////////

function dvsApplicationObject () {
	this.name;				// Name of application
	this.appID;				// Application ID
	this.imageURL;			// Image URl of application
	this.key;				// Key for application
	this.comment;			// Comment for application
	this.displayOptionName; // Option name to allow  displaying the object
	this.visible;			// visible params from dvs plugin setting
	this.contextMenuName;	// Name of context menu
	
	this.menuIds;			// Array of linked menu objects
	
	this.playlistButtonText;
	this.playlistImageURL;	// URL to playlist buttons image
	
	this.Init = function (appID, name, image, key, comment, displayOptionName, contextMenuName,playlistButtonText, playlistImageURL) {
		this.appID=appID;
		this.name=name;
		this.imageURL=chrome.extension.getURL(image);
		this.key=key;
		this.comment=comment;
		this.displayOptionName=displayOptionName;
		this.visible=true;
		this.contextMenuName=contextMenuName;
		this.playlistButtonText=playlistButtonText;
		this.playlistImageURL=chrome.extension.getURL(playlistImageURL);
		this.menuIds = new Array();
	}
	
	this.Run = function (url) {
		idmManager.download(this.appID, url);
	}
}

function createApplications() {
	youtubeDownloadApplications = new Array();

	youtubeDownloadApplications[0] = new dvsApplicationObject();
	youtubeDownloadApplications[0].Init(
	0,
	chrome.i18n.getMessage("free_youtube_download_app_name"),
	"images/YoutubeDownloader.png",
	"FreeYTVDownloader",
	chrome.i18n.getMessage("free_youtube_download_button_tooltip"),
	"showButtonsVideo",
	chrome.i18n.getMessage("free_youtube_download_context_menu_name"),
	chrome.i18n.getMessage("free_youtube_download_playlist_buttons_name"),
	"images/download.png");
	
	youtubeDownloadApplications[1]  = new dvsApplicationObject();
	youtubeDownloadApplications[1].Init(
	1,
	chrome.i18n.getMessage("free_youtube_to_mp3_converter_app_name"),
	"images/YoutubeToMp3.png",
	"FreeYoutubeToMP3Converter",
	chrome.i18n.getMessage("free_youtube_to_mp3_converter_button_tooltip"),
	"showButtonsMP3",
	chrome.i18n.getMessage("free_youtube_to_mp3_converter_context_menu_name"),
	chrome.i18n.getMessage("free_youtube_to_mp3_converter_playlist_buttons_name"),
	"images/headphone.png");
	
	getAppVisibility(youtubeDownloadApplications);
}

function getAppVisibility(apps) {
	for (var i=0; i< apps.length; i++) {
		 apps[i].visible=idmManager.isAppEnabled(apps[i].appID);
	}
}

/////////////////////////////////////////////////////////////////////
/////////  For NP plugin 
function logAllObjects(obj, objName){
    console.log("Children objects of " + objName +"-" +obj + "...");
    for (var i in obj) //      
       console.log( objName + "." + i + " = " + obj[i]);
    console.log("End children objects of " + objName);
   
}

/* Extend function  */
function extend(subClass, superClass) {
  var F = function() {};
  F.prototype = superClass.prototype;
  subClass.prototype = new F();
  subClass.prototype.constructor = subClass;
  subClass.superClass = superClass.prototype;
  if (superClass.prototype.constructor == Object.prototype.constructor) {
    superClass.prototype.constructor = superClass;
  }
}

function Downloader(plugin) {
  this.plugin = plugin;
}

Downloader.prototype.checkDownloader = function() {
  return this.plugin.CheckObject(this.progId);
}

Downloader.prototype.updateNPObjectIfNeeded = function() {
  if (!this.npObject)
    this.npObject = this.plugin.CreateObject(this.progId);
}

Downloader.prototype.resetNPObject = function() {
  this.npObject = null;
}

Downloader.prototype.download = function() {}
Downloader.prototype.downloadAll = function() {}

/* IDM */
function IDM(plugin) {
  IDM.superClass.constructor.apply(this, arguments);
  this.progId = 'DownlWithIDM.LinkProcessor';
  this.npObject = null;
  if (!this.npObject)
    this.npObject = this.plugin.CreateObject(this.progId);

	//logAllObjects(this.npObject,"npObject");
}

extend(IDM, Downloader);

IDM.prototype.download = function(appID,linkObj) {
  console.log("download (FreeYTVDownloader) - "+ linkObj);
  if (this.npObject == null)  console.log("NP object is NULL ");
  var res;
  if ((res = this.npObject.download(appID,linkObj)) == false) {
	console.log('[DVS] this.npObject.download FAILED');
  }
  console.log('res = ' + res);
}

IDM.prototype.isAppEnabled = function (appID) {
	if (this.npObject == null)  console.log("NP object is NULL ");
	var res = this.npObject.isAppEnabled(appID);
	return (res);
}
 
function createIdmManager() {
	var plugin = document.getElementById('pluginId');
	//logAllObjects(plugin,"plugin");
	idmManager = new IDM(plugin);
	while(idmManager.npObject == null) {
		createIdmManager();
	}
	console.log("Plugin loaded");
}


/////////////////////////////////////////////////////////////////////
// Scripts to run at start
/////////////////////////////////////////////////////////////////////
createIdmManager();
createApplications();
createContextMenu();
addListenerForContentScript();
/////////////////////////////////////////////////////////////////////
