﻿/////////////////////////////////////////////////////////////////////////
// Copyright DVDVideoSoft.com
// Version 1.0.0.0
// Content script of dvdvideosoft youtube download extension 
/////////////////////////////////////////////////////////////////////////

var messageInstallProgramm;
var youtubeDownloadApplications;		// Youtube download application
var options;

// Read options from background page and run object initialisations, if options readed
function readOptions() {
/*
	chrome.extension.sendRequest({"method":"getOptions"},function (result) 	{  
				if (result.boolResult == true) {
					options=result.objectResult;
					insertDVSyoutubeDownloadObjects();
				}
			});	
*/
	chrome.extension.sendRequest({"method":"getApplications"}, function (result) {
		if (result.boolResult == true) {
			youtubeDownloadApplications=result.apps;
			insertDVSyoutubeDownloadObjects();
		}
	});
}

// Insert Download Button on youtube page
function insertDVSyoutubeDownloadObjects() {

	insertWatchActionButton(youtubeDownloadApplications);
	insertChannelButton(youtubeDownloadApplications);
	insertPlaylistButton(youtubeDownloadApplications);
}

function insertWatchActionButton (app) {
	var watchAction=document.getElementById('watch-actions');
	
	if(watchAction != null)  {
		// old interface
		addButtons(watchAction,app,false);
	}	
	else {
		// new interface
		watchAction=document.getElementById('watch7-headline');
		if(watchAction != null)  {
			addButtons(watchAction,app,false);
		}	
	}
	
	// show page
	var indShow=document.location.href.indexOf("youtube.com/show/");
	var indVideos=document.location.href.indexOf("/videos");
	if(indShow != -1 && indVideos == -1) {
		var brandedPageBody=document.getElementById('branded-page-body');
		if(brandedPageBody) {
			var insPoints=getClass(brandedPageBody,"channels-featured-video-details","div");
			if(insPoints.length > 0 ) {
				var buttonsBlock = document.createElement('div');
				buttonsBlock.style.height="35px";
				buttonsBlock.style.marginTop="10px";
				buttonsBlock.style.marginBottom="10px";
				buttonsBlock.style.clear="both";
				insPoints[0].parentNode.insertBefore(buttonsBlock,insPoints[0]);
				addButtons(buttonsBlock,app,false);
			}
		}
	}
}

function insertChannelButton (app) {
	// For user channels only
	var channelHeader=document.getElementById('channel-header-main');
	var indShow=document.location.href.indexOf("youtube.com/show/");
	var indVideos=document.location.href.indexOf("/videos");
	if(channelHeader != null && (indShow == -1  || (indShow != -1 && indVideos != -1) ))  {
		var divs=channelHeader.getElementsByTagName('div');
		if (divs != null) {
			if (divs.length != 0) {
				var mainDiv=divs[0];
				
				// create left section
				var dvsMainDiv = document.createElement('div');
				dvsMainDiv.className="user_channel_buttons_block";

				// buttons
				addPlaylistButtons(dvsMainDiv,app,"channel")

				mainDiv.appendChild(dvsMainDiv);
			}
		}
	}	
}

function isAnyButtonDisplayed(app) {
	var result=false;
	for( var i=0; i<app.length; i++) {
		result=result || options[app[i].displayOptionName];
	}
	return(result);
}

function insertPlaylistButton (app) {
	if(document.URL.indexOf("playlist") > -1) {
		// For user channels only
		var channelHeader=document.getElementById('branded-page-header');
		if(channelHeader != null)  {
			var divs=channelHeader.getElementsByTagName('div');
			if (divs != null) {
				if (divs.length > 1) {
					var mainDiv=divs[1];
					
					// create left section
					var dvsMainDiv = document.createElement('div');
					dvsMainDiv.className="main_playlist_buttons_conteiner";
				
					// buttons
					addPlaylistButtons(dvsMainDiv,app,"playlist")

					mainDiv.appendChild(dvsMainDiv);
				}
			}
			
			// Correct play all button
			var playAllButton=document.getElementById("play-all-button");
			if(playAllButton != null) {
				playAllButton.style.marginTop="-3px";
			}
			
		}
	}	
}

function addPlaylistButtons(parentObject,app,buttonType) {
	for (var i=0; i<app.length; i++) {
		if (app[i].visible) {
			var bt = new dvsPlaylistButtonObject();
			bt.Init(app[i],"playlist_buttons");
			bt.btnType=buttonType;
			parentObject.appendChild(bt.button);
		}
	}	
}

// add applications buttons to parent object
// parentObject from DOM
// app - aplications array
// withTextFlag - if true, button  inserted with application name text
function addButtons(parentObject,app,withTextFlag) {
	// buttons
	for (var i=0; i<app.length; i++) {
		// if (options[app[i].displayOptionName]) 
		if (app[i].visible) {
			var bt = new dvsButtonObject();
			bt.Init(app[i]);
			if(withTextFlag) {
				var dvsProdBlock = document.createElement('div');
				dvsProdBlock.className="product_block";
				
				var textButton = document.createElement('span');
				textButton.innerHTML=app[i].name;
				textButton.style.cssFloat="left";
				textButton.style.marginTop="5px";
				textButton.btn=bt.btn;
				textButton.onclick=bt.SendEventToExtension;
					
				dvsProdBlock.appendChild(bt.button);
				dvsProdBlock.appendChild(textButton);
				parentObject.appendChild(dvsProdBlock);
			}
			else {
				parentObject.appendChild(bt.button);		
			}
		}
	}	
}

function insertChannelBar (app) {
	// For user channels only
	var channelHeader=document.getElementById('channel-header-main');
	if(channelHeader != null)  {
		var divs=channelHeader.getElementsByTagName('div');
		if (divs != null) {
			if (divs.length != 0) {
				var mainDiv=divs[0];
	
				// create main div
				var dvsMainDiv=document.createElement('div');
				dvsMainDiv.style.position="relative";
				dvsMainDiv.className="channel_header_bar";
				var backImageUrl="url('"+chrome.extension.getURL("images/backbar.png")+"')";
				dvsMainDiv.style.backgroundImage=backImageUrl;
				
				var  clearDiv=document.createElement('div');
				clearDiv.className="clearfloat10";
				
				mainDiv.appendChild(clearDiv);
				mainDiv.appendChild(dvsMainDiv);
				
				addButtons(dvsMainDiv,app,true);
			}
		}
	}	
}

function insertPlayListBar (app) {
	if(document.URL.indexOf("playlist") > -1) {
		var mainDiv=document.getElementById('branded-page-header');
		if(mainDiv != null)  {
			// create main div
			var dvsMainDiv=document.createElement('div');
			dvsMainDiv.style.position="relative";
			dvsMainDiv.className="channel_header_bar";
			
			var backImageUrl="url('"+chrome.extension.getURL("images/backbar.png")+"')";
			dvsMainDiv.style.backgroundImage=backImageUrl;
			dvsMainDiv.style.marginRight="30px";
				
			var  clearDiv=document.createElement('div');
			clearDiv.className="clearfloat10";
					
			mainDiv.appendChild(clearDiv);
			mainDiv.appendChild(dvsMainDiv);
					
			addButtons(dvsMainDiv,app,true);
		}
	}	
}

//////////////////////////////////////////////////////
//// DVS Objects

// dvs button object
function dvsPlaylistButtonObject () {
	
	this.button; 			// dvs button object
	this.application		// application oblect
	this.btn;				// self button object
	this.btnType="";		// type of button
	this.urlDownloadSuffix="#dvsbtn=all";	//url sufffix
	
	this.Init = function (app,className) {
		this.btn=this;
		this.application=app;
		this.button = document.createElement('div');
		this.button.btn=this;
		if(className == null)
			this.button.className="dvs_youtube_download_button";
		else
			this.button.className=className;
		//this.button.setAttribute("alt", app.comment);
		//this.button.style.backgroundImage="url("+app.playlistImageURL+")";
		//his.button.setAttribute("title", app.comment);
		this.button.onclick=this.SendEventToExtension ;
		this.btnType="playlist";
		
		
		var internalDiv = document.createElement('div');
		internalDiv.className="internal_div_button"+"_"+app.appID;
		internalDiv.style.backgroundImage="url("+app.playlistImageURL+")";
		internalDiv.innerHTML=app.playlistButtonText;
		
		this.button.appendChild(internalDiv);
		
	}
	
	this.SendEventToExtension = function (e) {
		chrome.extension.sendRequest({"appID":this.btn.application.appID, "type":this.btn.btnType, "url":document.URL+this.btn.urlDownloadSuffix, "method":"run"},this.btn.getRequestResult);
	}
	
	this.getRequestResult = function (result) {
		if(result == false)
		{
			//document.body.appendChild(messageInstallProgramm.messageBlock);
		}
	}
}

// dv button object
function dvsButtonObject () {
	
	this.button; 			// dvs button object
	this.application		// application oblect
	this.btn;				// self button object
	this.btnType="";		// type of button
	
	this.Init = function (app,className) {
		this.btn=this;
		this.application=app;
		this.button = document.createElement('img');
		this.button.btn=this;
		if(className == null)
			this.button.className="dvs_youtube_download_button";
		else
			this.button.className=className;
		this.button.setAttribute("alt", app.comment);
		this.button.src=app.imageURL;
		this.button.setAttribute("title", app.comment);
		this.button.onclick=this.SendEventToExtension ;
		this.btnType="watch";
	}
	
	this.SendEventToExtension = function (e) {
		chrome.extension.sendRequest({"appID":this.btn.application.appID, "type":this.btn.btnType, "url":document.URL, "method":"run"},this.btn.getRequestResult);
	}
	
	this.getRequestResult = function (result) {
		if(result == false)
		{
			//document.body.appendChild(messageInstallProgramm.messageBlock);
		}
	}
}

// Back Call Block oblect
function dvsMessageObject () {
	
	this.messageBlock;         // main back call block
	this.messageBlockContent;  // content block of window
	this.messageText; 			// text of message
	
	this.downloadLink;			// link to download programm
	this.pageLink;				// link to programm page
	this.imageURl;				// image button URl
	this.programmName			// programmName
	
	this.Init = function (text) {
		this.messageBlock=document.createElement('div');
		this.messageBlock.className="badCallBlock";
	
		this.messageBlockContent=document.createElement('div');
		this.messageBlockContent.className="badCallBlock_content";
		this.messageBlockContent.innerHTML=text;
		
		this.messageBlock.appendChild(this.messageBlockContent);
	}
}

function getClass(parent,name,type) {
	var r = [];
	var re = new RegExp("(^| )" + name + "( |$)");

	var e = parent.getElementsByTagName(type || "*");
	for ( var i = 0, len = e.length; i < len; i++ )
		if ( re.test(e[i].className) ) r.push( e[i] );

	return r;
}

/////////////////////////////////////////////////////
// Start scripts on run page
/////////////////////////////////////////////////////
readOptions();
/////////////////////////////////////////////////////