/*
 * @package 	websiteLogon
 * @author 		TrueSuite
 * @copyright (c) AuthenTec Inc.
 */
var websiteLogon = {
	currentPort: null,
	currentDocNum: 0,
	backgroundPage: null,
	userAccountofBoA: "",

	// Variable to define if the current page has submited by fill transaction:
	isSubmitForFilling: false,
	isSOLogonSucceeded: false,

	initialize: function() {
		try {
			console.log("<initialize> Entering... url: "+document.location.href);
		
			this.connectBG();
			if (this.processSpecialWebsite(false, true)) {
				return;
			}
			
			//special for hotmail.
			this.processHotmailPage();

            var isPasswordPage = this.isPasswordExists();
            if (isPasswordPage) {
                this.isSOLogonSucceeded = this.startToSOLogon(document.location.href);
            }
            
			this.attachSinkToForms();
		} catch (e) {
			console.error("<initialize> Exception:" + e);
		}
	},

	processSpecialWebsite: function(onlyCheck, onLoad) {
		console.log("<processSpecialWebsite> Entering");

		var isSpecialWebsite = false;
		var website = document.location.href;
		console.log("<processSpecialWebsite> " + website);

		switch (website) {
			case "http://www.stumbleupon.com/":
				isSpecialWebsite = true;
				if (!onlyCheck) {
					this.processWebsiteStumbleupon(onLoad);
				}
				break;

			case "https://sitekey.bankofamerica.com/sas/signonSetup.do":
				isSpecialWebsite = true;
				if (!onlyCheck) {
					this.processWebsiteBankOfAmerica(onLoad);
				}
				break;

			default:
				break;
		};

		if (website.indexOf("http://corp-cm/cruisecontrol/") > -1) {
			isSpecialWebsite = true;
			if (!onlyCheck) {
				this.processWebsiteCruisecontrol(onLoad);
			}
		}

		return isSpecialWebsite;
	},

    processWebsiteStumbleupon: function(onLoad) {
        console.log("<processWebsiteStumbleupon> entering");

        // attach the click event process
        var elemSubmitBtn = document.getElementsByName("login");
        if (typeof (elemSubmitBtn) != "undefined" && elemSubmitBtn) {
            elemSubmitBtn[0].addEventListener("click", function(event) { websiteLogon.onFormClick(event); }, false);
        }

        // try to logon
        if (onload) {
            this.sendBG({ cmd: "pageload", url: document.location.href, passwordstatus: true });
        } else {
            this.sendBG({ cmd: "tabselect", url: document.location.href, passwordstatus: true });
        }

        console.log("<onSubtreeModified> starttologon");
    },

    processWebsiteCruisecontrol: function(onLoad) {
        console.log("<processWebsiteStumbleupon> entering");

        // attach the click event process
        var elemSubmitBtn = document.getElementsByName("login");
        if (typeof (elemSubmitBtn) != "undefined" && elemSubmitBtn) {
            elemSubmitBtn[0].addEventListener("click", function(event) { websiteLogon.onFormClick(event); }, false);
        }

        // try to logon
        if (onload) {
            this.sendBG({ cmd: "pageload", url: document.location.href, passwordstatus: true });
        } else {
            this.sendBG({ cmd: "tabselect", url: document.location.href, passwordstatus: true });
        }
        console.log("<onSubtreeModified> starttologon");
    },

 	processWebsiteBankOfAmerica: function(onLoad) {
	   console.log("<processWebsiteBankOfAmerica> entering");
	   var bFoundSiteKey = false;
	   var rowAccount = "";
	   
	   // find the account name
	   var tables = document.forms.verifyImageForm.getElementsByTagName("table");
	  
	   for (var i=0 ; i < tables.length ; i++){
	         var rows = tables[i].getElementsByTagName("tr");
	         for ( var j = 0; j < rows.length ; j++) {
	             if(rows[j].innerHTML.indexOf("<a name=\"sitekey\">Your SiteKey<sup>" ) > -1){
	                 bFoundSiteKey = true;
	                 rowAccount = rows[j+2];
	                 break;
	             }	             
	         }
	         
	         if(bFoundSiteKey){
	             break;
	         }
	    }
	    
	    if (bFoundSiteKey) {
	        var varSpans =rowAccount.getElementsByTagName("span");
	        this.userAccountofBoA = varSpans[0].innerHTML;	      
	    }
	   
	   var signOn = document.getElementById("signon");
	   if (typeof(signOn)!="undefined"&&signOn) {
	       signOn.addEventListener("click",function(event){websiteLogon.onFormClick(event);},false);	   

	       // try to logon
           if (onLoad){
                this.sendBG({ cmd: "pageload", url: document.location.href, passwordstatus: true });   
           } else {
                this.sendBG({ cmd: "tabselect", url: document.location.href, passwordstatus: true });   
           }
                     
           console.log("<processWebsiteBankOfAmerica> starttologon");     
	   }//if(typeof(signOn)!="undefined"&&signOn)
	},

    connectBG: function() {
        console.log("<connectBG> Entering");
        this.currentPort = chrome.extension.connect({ name:document.location.href });
        if (typeof (this.currentPort) != "undefined" && this.currentPort) {
            console.log("<connectBG> currentPort: " + this.currentPort);
            this.currentPort.onMessage.addListener(function(msg) { websiteLogon.receiveBG(msg); });
            this.currentPort.onDisconnect.addListener(function() { websiteLogon.disconnectBG(); });
        }
    },

    disconnectBG: function() {
        if (this.currentPort) {
            this.currentPort.disconnect();
            this.currentPort = null;
        }
    },

    receiveBG: function(msg) {
        if (typeof (msg.cmd) == "undefined") {
            console.log("BG -> CS : INVALIDMSG");
            return
        }
        switch (msg.cmd) {
            case "setdocnum":
                console.log("<receiveBG> setdocnum: " + msg.docnum);
                this.currentDocNum = msg.docnum;
                
                if (!this.isSOLogonSucceeded) {
                    //sendBG must call after setdocnum, else docnum will be 0. 
                    var isPasswordPage = this.isPasswordExists();
			        this.sendBG({ cmd: "pageload", url: document.location.href, passwordstatus: isPasswordPage });
			    } else {
			        console.log("<receiveBG> SOLogon successfully.");
			    }
                break;
            case "tabcreated":
                console.log("<receiveBG> tabcreated");
                break;
            case "tabselected":
                console.log("<receiveBG> tabselected");
                if (this.processSpecialWebsite(false, false)) {
                    console.log("<receiveBG> tabswitch for special website");
                    break;
                }
                var isPasswordPage = this.isPasswordExists();
                this.sendBG({ cmd: "tabselect", url: document.location.href, passwordstatus: isPasswordPage });
                break;
            case "tabunselected":
                console.log("<receiveBG> tabunselected");
                this.abortTransaction();
                break;
            case "tabclosed":
                console.log("<receiveBG> tabclosed");
                this.abortTransaction();
                break;
            case "starttologon":
                console.log("<receiveBG> starttologon, docnum:" + this.currentDocNum + ", url: " + document.location.href);
                this.startToLogon(msg.url);
                break;
            case "starttoregister":
                console.log("<receiveBG> starttoregister, url: "+ document.location.href);
                this.startToRegister(msg.url, msg.formid, msg.userid, msg.password);
                break;
            default:
                break;
        }
    },

    sendBG: function(msg) {
        if (!this.currentPort) {
            console.log("CS -> BG : FAILED " + msg.cmd);
            return;
        } else {
            if (msg.passwordstatus) {
                console.log("<sendBG> msg.cmd:" + msg.cmd + ", docnum:" + this.currentDocNum + ", url:" + document.location.href);
            }
        }
        msg.docnum = this.currentDocNum;
        this.currentPort.postMessage(msg);
    },

    getBG: function() {
        if (this.backgroundPage != null) {
            return this.backgroundPage;
        }
        try {
            if (typeof (chrome.extension.getBackgroundPage) == "function") {
                this.backgroundPage = chrome.extension.getBackgroundPage();
                if (this.backgroundPage != null) {
                    return this.backgroundPage;
                }
            }
            return null;
        } catch (e) {
            console.error("TS : getBG FAILED error=" + e);
        }
        return null;
    },

    uninitailize: function() {
        try {
            console.log("<uninitailize> Entering");
            this.abortTransaction();
        } catch (e) {
            //alert("<uninitailize> Exception:"+e);
        }
    },

    fillPasswordProfile: function(mformid, muserid, mpassword, isubmit) {
        try {
            console.log("<fillPasswordProfile> Entering");
            if (muserid == "" || mpassword == "" || isubmit != 1) {
                return;
            }

            if (websiteLogon.processFillSpecialWebsite(muserid, mpassword, isubmit)) {
                console.log("<fillPasswordForm> processFillSpecialWebsite finished");
                return true;
            }

            var formArray = document.forms;
            for (var l = 0; l < formArray.length; l++) {
                if (this.fillPasswordForm(formArray[l], mformid, muserid, mpassword, isubmit)) {
                    return;
                }
            }
        } catch (e) {
            console.error("<fillPasswordProfile> Exception:" + e);
        }
    },

    fillPasswordForm: function(vform, vformid, vuserid, vpassword, vsubmit) {
        try {
            console.log("<fillPasswordForm> Entering... formname: "+vform.name);
            if (vuserid == "" || vpassword == "" || vsubmit != 1) {
                return false;
            }

            var useridField = null;
            var isFilled = false;
            try {
                var inputElements = vform.getElementsByTagName("input");
                console.log("<fillPasswordForm> inputElements.length=" + inputElements.length + ", vform.name=" + vform.name);
                //if(vform.name == vformid||mformid=="") {
                if (inputElements.length != 0) {
                    for (var i = 0; i < inputElements.length; i++) {
                        if (inputElements[i].type == "password") {
                            console.log("<fillPasswordForm> found password!!");
                            if (useridField != null) {
                                useridField.value = vuserid;
                            }
                            inputElements[i].value = vpassword;
                            isFilled = true;
                            break;
                        }

                        // add type email for vemio website, chrome seems not detect type correctly
                        if (inputElements[i].type.toLowerCase() == "text" || inputElements[i].type.toLowerCase() == "email") {
                            useridField = inputElements[i];
                        }
                    }
                } else {
                    //alert("inputElements.length==0");
                    var formElements = vform.elements;
                    for (var i = 0; i < formElements.length; i++) {
                        if (formElements[i].type == "password") {
                            if (useridField != null) {
                                useridField.value = vuserid;
                            }

                            formElements[i].value = vpassword;
                            isFilled = true;
                            break;
                        }

                        if (formElements[i].type.toLowerCase() == "text" || formElements[i].type.toLowerCase() == "email") {
                            useridField = formElements[i];
                        }
                    }
                }
                //}
            } catch (e) {
                isFilled = false;
                console.error("<fillPasswordForm> Exception1:" + e);
            }

            var isSubmited = false;
            if (isFilled) {
                if (vsubmit == 1) {
                    var formElements = vform.elements;

                    for (var i = 0; i < formElements.length; i++) {
                        //alert(formElements[i].name);
                        if ((formElements[i].type == "submit")) {
                            formElements[i].click();
                            isSubmited = true;
                            break;
                        }
                    }

                    if (!isSubmited) {
                        var iputelement = vform.getElementsByTagName("input");
                        for (var j = 0; j < iputelement.length; j++) {
                            if (iputelement[j].type == "image") {
                                iputelement[j].click();
                                isSubmited = true;
                                break;
                            }
                        }
                    }

                    if (!isSubmited) {
                        var linkelement = vform.getElementsByTagName("a");

                        for (var k = 0; k < linkelement.length; k++) {
                            if (linkelement[k].id.indexOf("SignIn") > -1) {
                                if (document.createEvent) { //FOR DOM2
                                    var ev = document.createEvent('HTMLEvents');
                                    ev.initEvent('click', false, true);
                                    linkelement[k].dispatchEvent(ev);
                                    isSubmited = true;
                                    break;
                                }
                            }
                        }
                    }

                    if (!isSubmited) {
                        vform.submit();
                    }
                }

                return true;
            }

            return false;
        } catch (e) {
            console.error("<fillPasswordForm> Exception2:" + e);
            return false;
        }
    },

	processFillSpecialWebsite: function(vuserid,vpassword,vsubmit) {
	    console.log("<processFillSpecialWebsite> enter: " + websiteLogon.userAccountofBoA+vuserid);
	    var website = document.location.href;
	    if (website == "https://sitekey.bankofamerica.com/sas/signonSetup.do") {
	        if (vuserid == websiteLogon.userAccountofBoA)
	        {
	           //fill the password and click the submit
	           var inputPw = document.getElementById("passcode");
	           inputPw.value = vpassword;
	           
	           var elemSubmitBtn = document.getElementById("signon");
			   if(typeof(elemSubmitBtn)!="undefined"&&elemSubmitBtn) {
	   			   if(document.createEvent) { //FOR DOM2
			          var ev = document.createEvent('HTMLEvents');
			          ev.initEvent('click', false, true);
			          elemSubmitBtn.dispatchEvent(ev);
		            }
				   
			    }
	        }
	    
	        // this is special website, return true to stop do normal process
	        return true;
	    }
	    
	    // not special website, return false to do normal process
	    return false;
	},

    isPasswordExists: function() {
        console.log("<isPasswordExists> Entering");

        var formArray = document.forms;
        //console.log("<isPasswordExistsInDocument> form length:"+formArray.length);
        for (var l = 0; l < formArray.length; l++) {
            if (this.isOnePasswordAndTextForm(formArray[l])) {
                return true;
            }
        }

        return false;
    },

    processHotmailPage: function() {
        try {
            if (document.location.href.indexOf("login.live.com") > -1) {
                var elem = document.getElementById("i1668");
                if (typeof (elem) != "undefined" && elem) {
                    console.log("<processHotmailPage> element: " + elem.outerHTML);
                    if (document.createEvent) { //FOR DOM2
                        var ev = document.createEvent('HTMLEvents');
                        ev.initEvent('click', false, true);
                        elem.dispatchEvent(ev);
                    }
                }
            }
        } catch (e) {
            console.error("<processHotmailPage> Exception: " + e);
        }
    },

    isOnePasswordForm: function(vform) {
        var passwordCount = 0;
        var inputArray = vform.getElementsByTagName("input");
        console.log("<isOnePasswordForm> inputArray.length:"+inputArray.length);
        if (inputArray.length != 0) {        
            for (var i = 0; i < inputArray.length; i++) {
                if (inputArray[i].type == "password") {
                    console.log("<isOnePasswordForm> found password.");
                    if (!this.isElementDisplayNone(inputArray[i]) || this.processSpecialWebsite(true, false)) {
                        console.log("<isOnePasswordForm> found display password.");
                        passwordCount++;
                    }
                }

                if (passwordCount > 1) {
                    break;
                }
            }
        } else {
            var formElements = vform.elements;
            for (var i = 0; i < formElements.length; i++) {
                if (formElements[i].type == "password") {
                    if (!this.isElementDisplayNone(formElements[i]) || this.processSpecialWebsite(true, false)) {
                        passwordCount++;
                    }
                }
                
                if (passwordCount > 1) {
                    break;
                }
            }
        }

        if (passwordCount == 1) {
            return true;
        }

        return false;
    },

    isOnePasswordAndTextForm: function(vform) {
        var passwordCount = 0;
        var textCount = 0;
        var inputArray = vform.getElementsByTagName("input");
        //console.log("<isOnePasswordAndTextForm> inputArray.length:"+inputArray.length);
        if (inputArray.length != 0) { 
            for (var i = 0; i < inputArray.length; i++) {
                var vType = inputArray[i].type;
                if (vType == "password") {
                    console.log("<isOnePasswordAndTextForm> found password.");
                    if (!this.isElementDisplayNone(inputArray[i]) || this.processSpecialWebsite(true, false)) {
                        console.log("<isOnePasswordAndTextForm> found display password.");
                        passwordCount++;
                    }
                } else if (vType == "text" || vType == "email") {
                    console.log("<isOnePasswordAndTextForm> found text.");
                    if (!this.isElementDisplayNone(inputArray[i]) || this.processSpecialWebsite(true, false)) {
                        console.log("<isOnePasswordAndTextForm> found display text.");
                        if (inputArray[i].title != null && inputArray[i].title.indexOf("search") > -1) {
                            console.log("<isOnePasswordAndTextForm> found display text. but this input is search input, not user name");
                        }
                        else {
                            textCount++;
                        }
                    }
                }

                if (passwordCount > 1 || textCount > 1) {
                    break;
                }
            }
        } else {
            //console.log("<isOnePasswordAndTextForm> getElementsByTagName failed");
            var formElements = vform.elements;
            for (var i = 0; i < formElements.length; i++) {
                if (formElements[i].type == "password") {
                    if (!this.isElementDisplayNone(formElements[i]) || this.processSpecialWebsite(true, false)) {
                        passwordCount++;
                    }
                } else if (formElements[i].type == "text" || formElements[i].type == "email") {
                    if (!this.isElementDisplayNone(formElements[i]) || this.processSpecialWebsite(true, false)) {
                        textCount++;
                    }
                }

                if (passwordCount > 1 || textCount > 1) {
                    break;
                }
            }
        }

        if (passwordCount == 1 && textCount == 1) {
            return true;
        }

        return false;
    },

    isElementDisplayNone: function(elem) {
        try {
            if (typeof (elem) != "undefine" && elem) {
                var style = document.defaultView.getComputedStyle(elem, null);
                if (style.display == "none") {
                    console.log("<isElementDisplayNone> password field is display:none");
                    return true;
                } else {
                    return this.isElementDisplayNone(elem.parentElement);
                }
            } else {
                console.log("<isElementDisplayNone> enum all elements");
            }
        } catch (e) {
            console.error("<isElementDisplayNone> Exception: " + e)
        }

        return false;
    },

    isElementEmpty: function(elem) {
        if (elem != null) {
            if (elem.value == "" || elem.value == null) {
                return true;
            } else {
                return false;
            }
        }

        return true;
    },

    attachSinkToForms: function() {
        try {
            console.log("<attachSinkToForms> Entering");
            var formArray = document.forms;
            for (var l = 0; l < formArray.length; l++) {
                try {
                    if (this.isOnePasswordForm(formArray[l])) {
                        console.log("<attachSinkToForms> attached formid:" + formArray[l].name);
                        formArray[l].addEventListener("click", function(event) { websiteLogon.onFormClick(event); }, false);
                    }
                } catch (e) {
                    console.error("<attachSinkToForms> Exception form name:" + formArray[l].name);
                }
            }
        } catch (ex) {
            console.error("<attachSinkToForms> Exception:" + ex);
        }
    },

    onFormClick: function(event) {
        //event.target provide element on which user clicked
        //this - refers to the form on which event has occured
        try {
            console.log("<onFormClick> Entering isSubmitForFilling:" + this.isSubmitForFilling);
            if ((!this.isSubmitForFilling) && this.isSubmitButton(event)) {
                console.log("<onFormClick> submit button clicked");
                this.sendProfileData();
            }
        } catch (e) {
            console.error("<onFormClick> Exception:" + e);
        }
    },

    isSubmitButton: function(event) {
        console.log("<isSubmitButton> Entering event:" + event);
        try {
            var eTarget = event.target;

            //Tag
            var vTag = eTarget.tagName.toLowerCase();
            //alert("vTag="+vTag);
            if (vTag != "input" && vTag != "button" && vTag != "img" && vTag != "span" && vTag != "a") {
                return false;
            }

            if (vTag == "span") {
                var eParent = eTarget.parentNode;
                var vParentTag = eParent.tagName.toLowerCase();
                if (vParentTag == "button") {
                    eTarget = eParent;
                    vTag = vParentTag;
                }
            }

            //Type
            var vType = eTarget.type;
            //alert("vType="+vType);
            if (vType == null || vType == "undefined") {
                vType = "";
            } else {
                vType = vType.toLowerCase();
            }
            if ((vTag == "input" && vType == "submit") || (vTag == "input" && vType == "image") || (vTag == "button" && vType == "submit")) {
                return true;
            }
            if (vType == "checkbox" || vType == "radio" || vType == "text" || vType == "password") {
                return false;
            }

            //outerHTML
            var vOuterHTML = eTarget.value;
            //alert("vOuterHTML="+vOuterHTML);
            if (vOuterHTML == null || vOuterHTML == "undefined") {
                vOuterHTML = "";
            } else {
                vOuterHTML = vOuterHTML.toLowerCase();
            }
            if (vOuterHTML.indexOf("reg") > -1 || vOuterHTML.indexOf("reset") > -1) {
                return false;
            }

            //Onclick
            var vOnclick = eTarget.getAttribute("onclick");
            //alert("vOnclick="+vOnclick);
            if (vOnclick == null || vOnclick == "undefined") {
                vOnclick = "";
            } else {
                vOnclick = vOnclick.toLowerCase();
            }
            //alert("vOnclick="+vOnclick);
            if (vOnclick.indexOf("reg") > -1 || vOnclick.indexOf("reset") > -1) {
                return false;
            }
            if ((vOnclick.indexOf("login") > -1) || (vOnclick.indexOf("javascript") > -1) || (vOnclick.indexOf("submit") > -1)) {
                return true;
            }

            //Class
            var vClassName = eTarget.className;
            //alert("vClassName="+vClassName);
            if (vClassName == null || vClassName == "undefined") {
                vClassName = "";
            } else {
                vClassName = vClassName.toLowerCase();
            }
            if (vClassName.indexOf("buttontext") > -1 || vClassName.indexOf("button_enter") > -1) {
                return true;
            }

            if (vTag == "img") {
                //alert("Image Element");
                eParent = eTarget.parentNode;
                vParentTag = eParent.tagName.toLowerCase();
                if (vParentTag == "a") {
                    //alert("Its image with anchor element");
                    var mHref = eParent.getAttribute("href").toLowerCase();
                    if (mHref.indexOf("javascript") > -1) {
                        return true;
                    }
                }
            } else if (vTag == "a") {
                var mHref = eTarget.getAttribute("href").toLowerCase();
                if (mHref.indexOf("javascript") != -1) {
                    return true;
                }

                var mOnClick = eTarget.getAttribute("onclick").toLowerCase();
                //alert("OnClick in OnFormClick");
                if (mOnClick != "" && mOnClick != "undefined") {
                    if (mOnClick.indexOf("login") > -1) {
                        return true;
                    }
                }
            } //else if(vTag == "span") {
            //var eParent = eTarget.parentNode;
            //var vParentTag = eParent.tagName.toLowerCase();
            //while(vParentTag!="form") {
            //if(vParentTag == "a") {
            //return true;
            //}
            //eParentNode = eParent.parentNode;
            //vParentTag = eParent.tagName.toLowerCase();
            //}
            //}

            return false;
        } catch (e) {
            console.error("<isSubmitButton> Exception:" + e);
            return false;
        }
    },

    sendProfileData: function() {
        console.log("<sendProfileData> Entering");
        try {
            var formArray = document.forms;
            for (var l = 0; l < formArray.length; l++) {
                var urlValue = document.location.href;
                var formidValue = formArray[l].name;
                var useridValue = "";
                var passwordValue = "";
                var passwordFound = false;

                console.log("<sendProfileData> form name = " + formidValue);
                var inputElements = formArray[l].getElementsByTagName("input");
                if (inputElements.length != 0) {
                    for (var i = 0; i < inputElements.length; i++) {
                        if (inputElements[i].type == "password") {
                            passwordValue = inputElements[i].value;
                            passwordFound = true;
                            if (useridValue == "") {
                                useridValue = inputElements[i - 1].value;
                            }

                            break;
                        }

                        if (inputElements[i].type == "text" || inputElements[i].getAttribute("class") == "text" || inputElements[i].type == "email") {
                            useridValue = inputElements[i].value;
                        }
                    }
                } else {
                    var formElements = formArray[l].elements;
                    for (var i = 0; i < formElements.length; i++) {
                        if (formElements[i].type == "password") {
                            passwordValue = formElements[i].value;
                            passwordFound = true;

                            break;
                        }
                        if (formElements[i].type == "text" || formElements[i].getAttribute("class") == "text" || formElements[i].type == "email") {
                            useridValue = formElements[i].value;
                        }
                    }
                }

                if (urlValue == "https://sitekey.bankofamerica.com/sas/signonSetup.do") {
                    console.log("Americabanck change the user id to " + this.userAccountofBoA);
                    console.log("Americabanck change the user id to " + websiteLogon.userAccountofBoA);
                    useridValue = this.userAccountofBoA;
                }

                if ((useridValue != "") && (passwordValue != "")) {
                    if (passwordFound) {
                        console.log("<sendProfileData> before calling startToRegister function");
                        this.sendBG({ cmd: "registersucceed" });
                        this.sendBG({ cmd: "formsubmit", url: urlValue, formid: formidValue, userid: useridValue, password: passwordValue });
                    }
                }
            }
        } catch (e) {
            console.error("<sendProfileData> Exception:" + e);
        }
    },

    addEmbed: function() {
        if (!window.ActiveXObject) {
            var embed = document.getElementById("embed_npwlo");
            if (!embed) {            
                embed = document.createElement("embed");
                embed.setAttribute("id", "embed_npwlo");
                embed.setAttribute("type", "application/npwlo");
                //embed.setAttribute("style", "display:none")
                embed.setAttribute("height", "0");
                document.body.appendChild(embed);
                
                var obj = document.createElement('object');
                obj.setAttribute("id", "embed_npwlo_data");
                obj.setAttribute("height", "0");
                document.body.appendChild(obj);
                
                obj.addEventListener("click", function(event) { setTimeout("websiteLogon.fillProfile()", 100); }, false);
                
            } else {
                console.log("<addEmbed> embed has been added.");
            }
        }
    },
    
    fillProfile: function() {
        console.log("<fillProfile> Entering...");
        this.sendBG({ cmd: "logonsucceed"});
        
        var obj = document.getElementById("embed_npwlo_data");
        var value1 = obj.getAttribute("value1");
        var value2 = obj.getAttribute("value2");
        var value3 = obj.getAttribute("value3");
        obj.removeAttribute("value1");
        obj.removeAttribute("value2");
        obj.removeAttribute("value3");
        this.isSubmitForFilling = true;
        this.fillPasswordProfile(value1, value2, value3, 1);
        this.isSubmitForFilling = false;
    },

    startToLogon: function(url) {
        console.log('<startToLogon> --'
					+ ' url: ' 			+ url);
        try {
        	this.addEmbed();
            var embed = document.getElementById("embed_npwlo");
            if (embed) {
                embed.StartToLogon(url);
            } else {
                console.log("<startToLogon> embed is null");
            }
        } catch (e) {
            console.error("<startToLogon> Exception:" + e);
        }
    },

    abortTransaction: function(){
        try {
        	this.addEmbed();
            var embed = document.getElementById("embed_npwlo");
            embed.AbortTransaction();
        } catch (e) {
            console.error("<startToRegister> Exception:" + e);
        }
    },

    startToRegister: function(url, formId, username, password) {
    	console.log('<startToRegister> --'
					+ ' url: ' 			+ url);
        try {
        	this.addEmbed();
            var embed = document.getElementById("embed_npwlo");
            embed.StartToRegister(url, formId, username, password);
        } catch (e) {
            console.error("<startToRegister> Exception:" + e);
        }
    },
    
    startToSOLogon: function(url) {
		console.log('<startToSOLogon> --'
					+ ' url: ' 			+ url);
		try{
		    this.addEmbed();
			var embed = document.getElementById("embed_npwlo");
			if(1 == embed.StartToSOLogon(url)){
			    return true;
			}
		}catch(e){
			console.error("<startToSOLogon> Exception:"+e);
		}
		
		return false;
	},
};

window.addEventListener("load", function() { websiteLogon.initialize(); }, false);
window.addEventListener("unload", function() { websiteLogon.uninitailize(); }, false);