/*
 * @package 	websiteLogonBG
 * @author 		TrueSuite
 * @copyright (c) AuthenTec Inc.
 */
var websiteLogonBG = {
	currentTabId: 0,
	CSTable: {},
	lastLogonTabId: 0,
	lastLogonUrl: "",
	lastLogonResult: false,
	
	// as the submit button click usually cause the page reload. 
	// we don't want to relogin, so we set a flag 
	// warn :if we found any website special we need *change* this design
	isPageLoadByRegister: false, 
	
	connectCS: function(port){		
		console.log("<connectCS> CS[" + port.tab.id + "] -> BG : CONNECT from tab with url=" + port.tab.url);
		
		if(typeof(this.CSTable[port.tab.id]) == "undefined" || !this.CSTable[port.tab.id]){
			this.CSTable[port.tab.id] = new Array();
		}
		
		var count = this.CSTable[port.tab.id].length;
		this.CSTable[port.tab.id][count] = port;
		this.sendCS(port.tab.id, {cmd:"setdocnum",docnum:count}, count);
		port.onMessage.addListener(function(msg,sender){ websiteLogonBG.receiveCS(sender.tab.id, msg, port) });
		port.onDisconnect.addListener(function(sender){ websiteLogonBG.disconnectCS(sender.tab.id) });
	},
	
	disconnectCS: function(tabId){
		console.log("<disconnectCS> Entering");
		if(typeof(this.CSTable[tabId]) != "undefined" && this.CSTable[tabId]){
			for(var i=0; i<this.CSTable[tabId].length; i++){
				this.CSTable[tabId][i].disconnect();
				this.CSTable[tabId][i] = null;
			}
			this.CSTable[tabId]=null;
		}
	},
	
	sendCS: function(tabId, msg, docnum){
		console.log("<sendCS> Entering tabId:" + tabId + ", docnum:" + docnum);
		if(tabId == "all"){
			for(var aCS in this.CSTable){
				for(var i=0; i<aCS.length; i++){
					this.sendCS(aCS[i], msg, i);
				}
			}
			return;
		}
		
		if(typeof(this.CSTable[tabId])=="undefined" || !this.CSTable[tabId]){
			console.log("BG -> CS["+tabId+"] : FAILED");
			return;
		}
		
		var startIndex=0,endIndex=0;
		if(typeof(docnum) != "undefined"){
			if(docnum == "all"){
				endIndex = this.CSTable[tabId].length-1;
			}else if(docnum < this.CSTable[tabId].length){
				startIndex = endIndex = docnum;
			}
		}
		
		for(var i=startIndex; i<=endIndex; i++){
			if(typeof(this.CSTable[tabId][i]) != "undefined" && this.CSTable[tabId][i]) {
				this.CSTable[tabId][i].postMessage(msg);
				console.log("<sendCS> CS["+tabId+"]["+i+"] : post succeed.");
			} else {
				console.error("<sendCS> CS["+tabId+"]["+i+"] : post failed.");
			}
		}
	},
	
	receiveCS: function(tabId, msg, port){
		if(typeof(msg.cmd) == "undefined"){
			console.log("CS["+tabId+"] -> BG : INVALIDMSG");
			return
		}
		if(!this.processCS(tabId, msg, port)){
			console.log("CS["+tabId+"] -> BG : INVALIDMSG")
		}
	},
	
	processCS: function(tabId, msg, port){
		switch(msg.cmd){
			case "tabselect":
			case "pageload":
				//Whether the current tab is selected or foreground.
				this.onLogonHandle(msg, tabId, port.tab);
				break;
			case "formsubmit":
			    this.onFormSubmit(msg, port.tab);
				break;
			case "registersucceed":
				this.isPageLoadByRegister = true;
				break;
			case "logonsucceed":
			    this.lastLogonResult = true;
			    break;
			default:
				return false;
		}
		
		return true;
	},
	
	onLogonHandle: function(msg, tabId, tab) {
		console.log('<onLogonHandle> --'
						+ ' url: ' 		+ msg.url
						+ ' tabId:'     + tabId );
						
		//http://www.pmi.org, multi frame website				
	    if (this.isDuplicateMessageFromMultiFrameWebsite(tab.url)) {
	        return;
	    }
	    
	    console.log("tab.status = " + tab.status);
	    if (tab.status == "complete") {
	    }
	    
		var isReenterByLogonFailed = (this.lastLogonTabId==tabId && this.lastLogonUrl==tab.url && msg.cmd=="pageload" && this.lastLogonResult);
		if (msg.url == tab.url) {
		    this.lastLogonResult = false;
		    this.lastLogonUrl = tab.url;
		}
		this.lastLogonTabId = tabId;
		
		if(this.isPageLoadByRegister && msg.cmd=="pageload") {
			console.log('<onLogonHandle> isPageLoadByRegister is true');
			this.isPageLoadByRegister = false;
			return;
		}
		
		this.isPageLoadByRegister = false;
		
		if(isReenterByLogonFailed) {
			console.log('<onLogonHandle> enter the same page after successfully verify to logon failed');
			return;
		}
		
		if(!msg.passwordstatus) {
			console.log('<onLogonHandle> passwordstatus is false');
			return;
		}
		
		if(msg.cmd=="pageload" && !tab.selected){
			console.log('<onLogonHandle> pageload and tab isnot selected');
			return;
		}
		
		this.sendCS(tab.id, { cmd:"starttologon", url: tab.url }, msg.docnum);
	},
	
	onFormSubmit: function(msg, tab) {
	    this.sendCS(tab.id, { cmd:"starttoregister", url: tab.url, formid: msg.formid, userid: msg.userid, password: msg.password }, msg.docnum);
	},

	isDuplicateMessageFromMultiFrameWebsite: function(url) {
	    if(url.indexOf("http://www.pmi.org/SiteCollectionDocuments/HomePageAds.html") > -1 ||
	       url.indexOf("http://www.pmi.org/SiteCollectionDocuments/HomePageSkyscraper.html") > -1 ||
	       url.indexOf("http://img-cdn.mediaplex.com/0/11086/universal.html?page_name") > -1
	       ) {
	           return true;
	       }
	    return false;
	},	

	initTabEvent: function() {
		console.log("<initTabEvent> Entering");
		//tab create event
		chrome.tabs.onCreated.addListener(
			function(tab) {
  			    console.log('tabs.onCreated --'
                  + ' window: ' + tab.windowId
                  + ' tab: '    + tab.id
                  + ' index: '  + tab.index
                  + ' url: '    + tab.url);
                websiteLogonBG.sendCS(tab.id, {cmd:"tabcreated"}, "all");
			}
		);

		//tab select event
		chrome.tabs.onSelectionChanged.addListener(
			function(tabId, selectInfo) {
				console.log('tabs.onSelectionChanged --'
							+ ' tab: '    + tabId);
				websiteLogonBG.tabSelectionChanged(tabId);
			}
		);

		//tab close event
		chrome.tabs.onRemoved.addListener(
			function(tabId) {
				console.log('tabs.onRemoved --'
							+ ' tab: '    + tabId);
				websiteLogonBG.sendCS(tabId, {cmd:"tabclosed"}, "all");
			}
		);
	},
	
	tabSelectionChanged: function(tabId){
		if(tabId != this.currentTabId) {
			this.sendCS(this.currentTabId, {cmd:"tabunselected"}, "all");
			this.sendCS(tabId, {cmd:"tabselected"}, "all");
			this.currentTabId = tabId;
		}
	},
};

function onLoad() {
	console.log("<onLoad> Entering");
	websiteLogonBG.initTabEvent();
}

chrome.extension.onConnect.addListener(function(port){ websiteLogonBG.connectCS(port) });

